/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.BackwardWallJumpAnimator;
import com.alrex.parcool.client.animation.impl.WallJumpAnimator;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WallJump
extends Action {
    private boolean jump = false;

    public boolean justJumped() {
        return this.jump;
    }

    @Override
    public void onTick(Player player, Parkourability parkourability, IStamina stamina) {
        this.jump = false;
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private Vec3 getJumpDirection(Player player, Vec3 wall) {
        if (wall == null) {
            return null;
        }
        wall = wall.m_82541_();
        Vec3 lookVec = player.m_20154_();
        Vec3 vec = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_).m_82541_();
        if (wall.m_82526_(vec) > 0.5) {
            return null;
        }
        return vec.m_82541_().m_82549_(wall.m_82490_(-0.7));
    }

    @Override
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        boolean value;
        Vec3 wallDirection = WorldUtil.getWall((LivingEntity)player);
        Vec3 jumpDirection = this.getJumpDirection(player, wallDirection);
        if (jumpDirection == null) {
            return false;
        }
        ClingToCliff cling = parkourability.get(ClingToCliff.class);
        boolean bl = value = !stamina.isExhausted() && parkourability.getActionInfo().can(WallJump.class) && !player.m_20096_() && !player.m_20072_() && !player.m_21255_() && !player.m_150110_().f_35935_ && parkourability.getAdditionalProperties().getNotCreativeFlyingTick() > 10 && (!cling.isDoing() && cling.getNotDoingTick() > 3 || cling.isDoing() && cling.getFacingDirection() != ClingToCliff.FacingDirection.ToWall) && KeyRecorder.keyWallJump.isPressed() && !parkourability.get(Crawl.class).isDoing() && parkourability.getAdditionalProperties().getNotLandingTick() > 5 && WorldUtil.getWall((LivingEntity)player) != null;
        if (!value) {
            return false;
        }
        Vec3 dividedVec = new Vec3(wallDirection.f_82479_ * jumpDirection.f_82479_ + wallDirection.f_82481_ * jumpDirection.f_82481_, 0.0, -wallDirection.f_82479_ * jumpDirection.f_82481_ + wallDirection.f_82481_ * jumpDirection.f_82479_).m_82541_();
        Vec3 lookVec = player.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_();
        Vec3 lookDividedVec = new Vec3(lookVec.f_82479_ * wallDirection.f_82479_ + lookVec.f_82481_ * wallDirection.f_82481_, 0.0, -lookVec.f_82479_ * wallDirection.f_82481_ + lookVec.f_82481_ * wallDirection.f_82479_).m_82541_();
        WallJumpAnimationType type = lookDividedVec.f_82479_ > 0.5 ? WallJumpAnimationType.Back : (dividedVec.f_82481_ > 0.0 ? WallJumpAnimationType.SwingRightArm : WallJumpAnimationType.SwingLeftArm);
        startInfo.putDouble(jumpDirection.f_82479_).putDouble(jumpDirection.f_82481_).putDouble(wallDirection.f_82479_).putDouble(wallDirection.f_82481_).put(type.getCode());
        return true;
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return false;
    }

    @Override
    public void onStart(Player player, Parkourability parkourability) {
        this.jump = true;
        player.f_19789_ = 0.0f;
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        float slipperiness;
        double speedScale = (double)player.m_20205_() / 0.6;
        Vec3 jumpDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble()).m_82490_(speedScale);
        Vec3 direction = new Vec3(jumpDirection.f_82479_, 1.512, jumpDirection.f_82481_).m_82490_(0.3);
        Vec3 wallDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        Vec3 motion = player.m_20184_();
        BlockPos leanedBlock = new BlockPos(player.m_20185_() + wallDirection.f_82479_, player.m_20186_() + (double)player.m_20206_() * 0.25, player.m_20189_() + wallDirection.f_82481_);
        float f = slipperiness = player.f_19853_.m_46749_(leanedBlock) ? player.f_19853_.m_8055_(leanedBlock).getFriction((LevelReader)player.f_19853_, leanedBlock, (Entity)player) : 0.6f;
        double ySpeed = (double)slipperiness > 0.9 ? motion.m_7098_() : (motion.f_82480_ > direction.f_82480_ ? motion.f_82480_ + direction.f_82480_ : direction.f_82480_);
        player.m_20334_(motion.f_82479_ + direction.f_82479_, ySpeed, motion.f_82481_ + direction.f_82481_);
        WallJumpAnimationType type = WallJumpAnimationType.fromCode(startData.get());
        Animation animation = Animation.get(player);
        if (animation != null) {
            switch (type) {
                case Back: {
                    animation.setAnimator(new BackwardWallJumpAnimator());
                    break;
                }
                case SwingLeftArm: {
                    animation.setAnimator(new WallJumpAnimator(false));
                    break;
                }
                case SwingRightArm: {
                    animation.setAnimator(new WallJumpAnimator(true));
                }
            }
        }
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        startData.position(32);
        WallJumpAnimationType type = WallJumpAnimationType.fromCode(startData.get());
        Animation animation = Animation.get(player);
        if (animation != null) {
            switch (type) {
                case Back: {
                    animation.setAnimator(new BackwardWallJumpAnimator());
                    break;
                }
                case SwingLeftArm: {
                    animation.setAnimator(new WallJumpAnimator(false));
                    break;
                }
                case SwingRightArm: {
                    animation.setAnimator(new WallJumpAnimator(true));
                }
            }
        }
    }

    private static enum WallJumpAnimationType {
        Back(0),
        SwingRightArm(1),
        SwingLeftArm(2);

        private byte code;

        private WallJumpAnimationType(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        public static WallJumpAnimationType fromCode(byte code) {
            switch (code) {
                case 1: {
                    return SwingRightArm;
                }
                case 2: {
                    return SwingLeftArm;
                }
            }
            return Back;
        }
    }
}

